* 99 tables.do makes tables 1,X2 A1.  Tables are written to excel file "99 tables" and formatted there.
*version 17
#d ;
clear;
set type double ;
set more off;
set linesize 180;
cap log close;
pause on;

log using "${log}99 Tables.log", replace;
use "${CE}/ce_cpc_comb_haall_v7.dta", clear;
count;

foreach x in c_rinkind c_rwic c_rschlunch c_rliheap c_rhousesub {;
	gen pos_`x'=`x'>0;
};
***************;
* Note: to match CE we should exclude from CPS 7 states FIPS 19,35,38,50,56,44,40 where there is no CE data.
* unfortunately our CPSP data does not include State so we cannot.  So the samples will differ.;
 
label var c_rinc_winkindnoadj "Income Before Tax with in-kind, no adj";
label var c_rinck "Net Income";
label var c_rexp_resource_noadjust "Gross Expenditure";
label var c_rexpk_noadj "Expenditure with in-kind no adj";
label var c_rexp "Expenditure no in-kind with adj";
label var c_rexpk "Net Expenditure";
label var c_noncash "Total In-kind";
label var c_rliheap "Energy Asst.";
label var c_unadjust_rinc_noinkind2 "Gross Income";
tab c_house_grp, gen(thousegrp);
label var thousegrp1 "Owners with Mortgage";
label var thousegrp2 "Owners without Mortgage";
label var thousegrp3 "Renters";
label var c_fam_size "Family Size";
label var c_nchild "Number of Children";
label var c_nadult "Number of Adults";
label var c_elderly "Presence of Elderly";

gen c_adjust_notax=c_radjustments - c_rtaxm2;
label var c_adjust_notax "Non-tax Adjustments";

* resources without transfers.  transfers have no missings;
gen c_rinck_xf=c_rinck - c_rsnap;
gen c_rinck_xfh = c_rinck_xf-c_rhousesub;
gen c_rinck_xfhl = c_rinck_xfh-c_rschlunch;
gen c_rinck_xfhlw = c_rinck_xfhl-c_rwic;
gen c_rinck_xfhlwe = c_rinck_xfhlw-c_rliheap;

gen c_princk_xf= c_rinck_xf < c_rspm_thres; 
gen c_princk_xfh = c_rinck_xfh < c_rspm_thres;
gen c_princk_xfhl = c_rinck_xfhl < c_rspm_thres;
gen c_princk_xfhlw = c_rinck_xfhlw < c_rspm_thres;
gen c_princk_xfhlwe = c_rinck_xfhlwe < c_rspm_thres;

gen c_rexpk_xf=c_rexpk - c_rsnap;
gen c_rexpk_xfh = c_rexpk_xf-c_rhousesub;
gen c_rexpk_xfhl = c_rexpk_xfh-c_rschlunch;
gen c_rexpk_xfhlw = c_rexpk_xfhl-c_rwic;
gen c_rexpk_xfhlwe = c_rexpk_xfhlw-c_rliheap;

gen c_prexpk_xf= c_rexpk_xf < c_rspm_thres; 
gen c_prexpk_xfh = c_rexpk_xfh < c_rspm_thres;
gen c_prexpk_xfhl = c_rexpk_xfhl < c_rspm_thres;
gen c_prexpk_xfhlw = c_rexpk_xfhlw < c_rspm_thres;
gen c_prexpk_xfhlwe = c_rexpk_xfhlwe < c_rspm_thres;

* demographic vars for CE;
label var fam_type "Family Type";
label var ref_race "Race of Ref Person";
label var hisp_ref "Hispanicity Ref Person";
qui tab c_educref, g(educt);
qui tab c_race, g(race);
gen c_chldpres= c_nchild>0 & c_nchild<.;
label var elderly "Elderly Ref Person";

* compute 20th pctle;
gen pct20rinc=.;
_pctile c_unadjust_rinc_noinkind2 [aweight=c_perpopwt] if asec==1 & inlist(year,2017,2018,2019), percentiles(20);
replace pct20rinc= c_unadjust_rinc_noinkind2 <r(r1) if asec==1 & inlist(year,2017,2018,2019);
_pctile c_unadjust_rinc_noinkind2 [aweight=c_perpopwt] if asec==0 & inlist(year,2017,2018,2019), percentiles(20);
replace pct20rinc= c_unadjust_rinc_noinkind2 <r(r1) if asec==0 & inlist(year,2017,2018,2019);

*topcode taxes at top 2%;
gen c_rtaxtopped=c_rtaxm2;
_pctile c_rtaxm2 [aweight=c_perpopwt] if pct20rinc==1 & asec==1 & inlist(year,2017,2018,2019), percentiles(98);
replace c_rtaxtopped = r(r1) if c_rtaxm2>r(r1) & c_rtaxm2<. & pct20rinc==1 & asec==1 & inlist(year,2017,2018,2019);
_pctile c_rtaxm2 [aweight=c_perpopwt] if pct20rinc==1 & asec==0 & inlist(year,2017,2018,2019), percentiles(98);
replace c_rtaxtopped = r(r1) if c_rtaxm2>r(r1) & c_rtaxm2<. & pct20rinc==1 & asec==0 & inlist(year,2017,2018,2019);
label var c_rtaxtopped "Taxes (2% topcode)";

*local tablist0 "c_agelt18 c_age1864 c_ageot64";
local tablist1 "c_fam_size c_nchild c_nadult c_elderly age_ref thousegrp1 thousegrp2 thousegrp3 educt1 educt2 educt3 race1 race2 race3 race4" ;
local tablist2 "c_rexp_resource_noadjust c_rexpk c_unadjust_rinc_noinkind2 c_rinck ";
local tablist3 "c_adjust_notax c_rhealth c_rCapWknChCareXpns c_rchildsupport c_rtaxtopped" ;
local tablist4 "c_noncash c_rschlunch c_rliheap c_rsnap c_rwic c_rhousesub" ;
*local tablist5 "c_poor_rexpk c_poor_rexp_noknoadj c_poor_rinck c_poor_rinc_noknoadj " ;
local tablist5 "gross_pr net_pr";
local tablist6 " c_poor_rexp_nokwadj c_poor_rexp_knoadj  c_poor_rexp_official";
*local tablist7 "c_poor_rinck c_poor_rexpk";

* Restrict sample size;
*keep if year == 2019;
keep if inlist(year,2017,2018,2019);

* Spending/Income stats ;
* after tax with SNAP ;
gen c_rinc_aftertax=c_rfinc_addfsm-c_rtaxm2;
gen c_poor_rinc_aftertax=c_rinc_aftertax<c_rspm_thres if c_rspm_thres<.;

gen c_rinc_aftertax_net = (c_rinc_aftertax) + (c_rinkind) - (c_rchildsupport + c_rCapWknChCareXpns + c_rhealth) ; 

gen gross_income = c_rexp_resource_noadjust if asecsurvey == 0 ;
replace gross_income = c_rinc_aftertax if asecsurvey == 1 ;

gen net_income = c_rexpk if asecsurvey == 0 ;
replace net_income = c_rinc_aftertax_net if asecsurvey == 1 ;

gen gross_pr = c_poor_rexp_noknoadj if asecsurvey == 0 ;
replace gross_pr = c_poor_rinc_aftertax if asecsurvey == 1 ; 

gen net_pr = c_poor_rexpk if asecsurvey == 0 ;
replace net_pr = c_poor_rinck if asecsurvey == 1 ; 

* TABLE 1 ; 
preserve;
	foreach var in /*ce_rexp_noadj c_rinc_aftertax c_rinc_aftertax_net*/ gross_income net_income{;
		foreach stat in MEAN SD P01 P05 P03 P10 P20 P50{;
			gen `stat'`var' = `var';
		};
	};

	forval tl=1/5{;
		foreach var in `tablist`tl''{;
			foreach stat in MEAN SD P50{;
				if `tl' < 5 gen `stat'`var' = `var' if pct20rinc == 1;
				else gen `stat'`var' = `var';
			};
		};
	};

	gen N = 1;

	gen MEANtotal_inkind_nosnap = c_noncash - c_rsnap if pct20rinc == 1;
	gen SDtotal_inkind_nosnap = c_noncash - c_rsnap if pct20rinc == 1;

	collapse (sum) N (mean) MEAN* (semean) SD* (p1) P01* (p3) P03* (p5) P05* (p10) P10* (p20) P20* (p50) P50* [aweight=c_perpopwt], by(asecsurvey) ;
	gen _mi_miss=0;
	gen _mi_id=0;
	mi extract 0, clear;
	reshape long MEAN SD P01 P03 P05 P10 P20 P50 , i(asecsurvey N) j(variable) str;
	reshape wide N MEAN SD P01 P03  P05 P10 P20 P50, i(variable) j(asecsurvey);

	* Limit fields;
	keep if inlist(variable,"gross_income", "net_income") | inlist(variable,"gross_pr", "net_pr") | inlist(variable,"c_adjust_notax","c_rhealth","c_rCapWknChCareXpns","c_rchildsupport","c_rtaxtopped") | inlist(variable,"c_noncash","c_rschlunch","c_rliheap","c_rsnap","c_rwic","c_rhousesub", "total_inkind_nosnap") | inlist(variable,"c_fam_size","c_nchild","c_nadult","c_elderly","thousegrp1","thousegrp2","thousegrp3") ;

	gen t_sort = _n ;
	replace t_sort = 1 if variable == "gross_income";
	replace t_sort = 2 if variable == "net_income";
	replace t_sort = 3 if variable == "gross_pr";
	replace t_sort = 4 if variable == "net_pr";
	replace t_sort = 5 if variable == "c_rhealth";
	replace t_sort = 6 if variable == "c_rCapWknChCareXpns";
	replace t_sort = 7 if variable == "c_rchildsupport";
	replace t_sort = 8 if variable == "c_adjust_notax";
	replace t_sort = 9 if variable == "c_rtaxtopped" ;
	replace t_sort = 10 if variable == "c_rschlunch";
	replace t_sort = 11 if variable == "c_rliheap";
	replace t_sort = 12 if variable == "c_rsnap";
	replace t_sort = 13 if variable == "c_rwic";
	replace t_sort = 14 if variable == "c_rhousesub";
	replace t_sort = 15 if variable == "c_noncash";
	replace t_sort = 15.1 if variable == "total_inkind_nosnap";
	replace t_sort = 16 if variable == "c_fam_size";
	replace t_sort = 17 if variable == "c_nchild";
	replace t_sort = 18 if variable == "c_nadult";
	replace t_sort = 19 if variable == "c_elderly";
	replace t_sort = 20 if variable == "thousegrp1";
	replace t_sort = 21 if variable == "thousegrp2";
	replace t_sort = 22 if variable == "thousegrp3";
	sort t_sort ;

	gen var = variable, after(variable) ;
	replace var = "Gross Expenditure or Gross Adjusted Income" if variable == "gross_income";
	replace var = "Net Expenditure or Net Adjusted Income" if variable == "net_income";
	replace var = "Gross SEPM or SIPM" if variable == "gross_pr";
	replace var = "Net SEPM or SIPM" if variable == "net_pr";
	replace var = "Medical Out-of-Pocket Spending" if variable == "c_rhealth";
	replace var = "Work Expenses + Childcare" if variable == "c_rCapWknChCareXpns";
	replace var = "Child Support" if variable == "c_rchildsupport";
	replace var = "Total Adjustments" if variable == "c_adjust_notax";
	replace var = "Taxes (2% Topcode)" if variable == "c_rtaxtopped" ;
	replace var = "School Lunch Subsidy" if variable == "c_rschlunch";
	replace var = "Energy Asst." if variable == "c_rliheap";
	replace var = "SNAP" if variable == "c_rsnap";
	replace var = "WIC" if variable == "c_rwic";
	replace var = "Total In-Kind" if variable == "c_noncash";
	replace var = "Total In-Kind" if variable == "total_inkind_nosnap";
	replace var = "Housing Subsidy" if variable == "c_rhousesub";
	replace var = "Family Size" if variable == "c_fam_size";
	replace var = "Children" if variable == "c_nchild";
	replace var = "Adults" if variable == "c_nadult";
	replace var = "Presence of Elderly" if variable == "c_elderly";
	replace var = "Own w/ Mortgage" if variable == "thousegrp1";
	replace var = "Own no Mortgage" if variable == "thousegrp2";
	replace var = "Renters" if variable == "thousegrp3";

	for var MEAN1 SD1 : replace X = . if inlist(var, "Gross SEPM","Net SEPM");

	expand 2 if variable == "thousegrp3";
	replace var = "Sample Size" if _n == _N ;
	replace MEAN0 = N0 if _n == _N ;
	replace MEAN1 = N1 if _n == _N ;
	drop N0 N1 ;
	for var SD0 P500 P010 P030 P050 P100 P200 SD1 P501 P011 P031 P051 P101 P201 : replace X = . if _n == _N;
	replace t_sort = _N if _n == _N;
	gen stat = "", after(var);
	foreach var in gross_income net_income{;

		expand 7 if variable == "`var'";
		gen t_sort2 = _n;
		local i = 1;
		foreach stat in "Mean" "Median" "1st Percentile" "3rd Percentile" "5th Percentile" "10th Percentile" "20th Percentile"{;
			bys t_sort (t_sort2): replace stat = "`stat'" if _n == `i' & _N > 1;
			if `i' > 1{;
				forval samp = 0/1{;
					bys t_sort : replace SD`samp' = . if _n == `i' & _N > 1;
					if "`stat'" == "1st Percentile" bys t_sort (t_sort2): replace MEAN`samp' = P01`samp' if _n == `i' & _N > 1;
					else if "`stat'" == "3rd Percentile" bys t_sort (t_sort2): replace MEAN`samp' = P03`samp' if _n == `i' & _N > 1;
					else if "`stat'" == "5th Percentile" bys t_sort (t_sort2): replace MEAN`samp' = P05`samp' if _n == `i' & _N > 1;
					else if "`stat'" == "10th Percentile" bys t_sort (t_sort2): replace MEAN`samp' = P10`samp' if _n == `i' & _N > 1;
					else if "`stat'" == "20th Percentile" bys t_sort (t_sort2): replace MEAN`samp' = P20`samp' if _n == `i' & _N > 1;
					else if "`stat'" == "Median" bys t_sort (t_sort2): replace MEAN`samp' = P50`samp' if _n == `i' & _N > 1;
				};
			};
			local ++i;
		};
		drop t_sort2;
	};
	keep var stat MEAN0 SD0 MEAN1 SD1 t_sort;

	label var var " " ;
	label var stat " " ;
	label var MEAN0 "Statistic"; 
	label var SD0 "SE" ;
	label var MEAN1 "Statistic"; 
	label var SD1 "SE";

	* Ad-hoc changes;
	drop if var == "Total In-Kind" & t_sort == 15;
	drop t_sort;
	drop if inlist(var, "Taxes (2% Topcode)", "SNAP");
	for var MEAN1 MEAN0 : replace X = 0 if X < 0 & !mi(stat);
	for var SD1 SD0 : replace  X = . if inlist(var,"Gross SEPM or SIPM","Net SEPM or SIPM", "Presence of Elderly","Own w/ Mortgage","Own no Mortgage","Renters");

	export excel using "${outgraph}99 Tables.xlsx", sheet("r.Table 1") sheetreplace firstrow(varlabel) ; 

restore ; 

foreach var in ce_rexp_noadj c_rexpk c_rinc_aftertax c_rinc_aftertax_net{;
	gen c_pdeep_`var' = `var' < (c_rspm_thres/2) if c_rspm_thres<.;
	gen c_poor_`var' = `var' < c_rspm_thres if c_rspm_thres<.;
	gen c_pnear_`var' = `var' < (c_rspm_thres*1.5) if c_rspm_thres<.;
};
*pause;
* TABLE X2 Near and Deep Poverty. for figure 4;
preserve;


	ds c_pdeep_ce_rexp_noadj c_poor_ce_rexp_noadj c_pnear_ce_rexp_noadj c_pdeep_c_rexpk c_poor_c_rexpk c_pnear_c_rexpk c_pdeep_c_rinc_aftertax c_poor_c_rinc_aftertax c_pnear_c_rinc_aftertax c_pdeep_c_rinc_aftertax_net c_poor_c_rinc_aftertax_net c_pnear_c_rinc_aftertax_net; 
	collapse (mean) `r(varlist)' [aweight=c_perpopwt], by(asecsurvey) ;
	
	gen _mi_miss=0;
	gen _mi_id=0;
	mi extract 0, clear;
	reshape long c_pdeep_ c_poor_ c_pnear_ , i(asecsurvey) j(rates) str ;
	reshape long c_ , i(asecsurvey rates) j(pov_stat) str ;
	reshape wide c_, i(pov_stat rates) j(asecsurvey) ;

	replace pov_stat = "Poverty" if pov_stat == "poor_" ;
	replace pov_stat = "Near-Poverty" if pov_stat == "pnear_" ;
	replace pov_stat = "Deep Poverty" if pov_stat == "pdeep_" ;
	
	gen rates2 = "Net" if inlist(rates,"c_rexpk","c_rinc_aftertax_net"),after(rates);
	replace rates2 = "Gross" if inlist(rates,"ce_rexp_noadj","c_rinc_aftertax");
	replace c_0 = 0 if inlist( rates, "c_rinc_aftertax_net", "c_rinc_aftertax") ;
	sort rates2 pov_stat;
	collapse (sum) c_* , by(rates2 pov_stat) ; 

	gen t_sort = rates2 != "Gross";
	gen t_sort2 = 2;
	replace t_sort2 = 1 if strpos(pov_stat,"Deep") >0 ;
	replace t_sort2 = 3 if strpos(pov_stat,"Near") > 0 ;
	sort t_sort2 t_sort;
		
	order pov_stat rate c_0 c_1 ; 
	keep pov_stat rate c_0 c_1 ;
	label var pov_stat " " ;
	label var rate "Expenditure or Adjusted Income" ;
	label var c_0 "SEPM" ;
	label var c_1 "SIPM" ;
	
	export excel using "${outgraph}99 Tables.xlsx", sheet("r.Table X2") sheetreplace firstrow(varlabel) ; 

restore;

* TABLE A1 ; 
local tablist0 "c_agelt18 c_age1864 c_ageot64";
local tablist1 "c_fam_size c_nchild c_nadult c_elderly age_ref thousegrp1 thousegrp2 thousegrp3 educt1 educt2 educt3 race1 race2 race3 race4" ;
*local tablist2 "c_rexp_resource_noadjust c_rexpk c_unadjust_rinc_noinkind2 c_rinck ";
local tablist3 "c_adjust_notax c_rhealth c_rCapWknChCareXpns c_rchildsupport c_rtaxtopped" ;
local tablist4 "c_noncash c_rschlunch c_rliheap c_rsnap c_rwic c_rhousesub" ;
*local tablist5 "c_poor_rexpk c_poor_rexp_noknoadj c_poor_rinck c_poor_rinc_noknoadj " ;
*local tablist6 " c_poor_rexp_nokwadj c_poor_rexp_knoadj  c_poor_rexp_official";
*local tablist7 "c_poor_rinck c_poor_rexpk";

preserve ; 

	keep if asecsurvey == 1 ; 
	collapse (median) c_rinc_aftertax c_rinc_aftertax_net (mean) `tablist1' `tablist3' `tablist4' [aweight=c_popwt], by(c_poor_c_rinc_aftertax_net) ; 
	for var age_ref thousegrp1 thousegrp2 thousegrp3 educt1 educt2 educt3 race1 race2 race3 race4: ren X c_X;
	gen _mi_miss=0;
	gen _mi_id=0;
	mi extract 0, clear;
	reshape long c_, i(c_poor_c_rinc_aftertax_net) j(variable) str ;
	keep if !mi(c_poor_c_rinc_aftertax_net) ;
	reshape wide c_, i(variable) j(c_poor_c_rinc_aftertax_net) ;
	keep if !mi(c_0) & !mi(c_1) ; 
	keep variable c_1 ;
	ren c_1 sipm_poor ;
	save "${temp}99 SIPM poor means.dta", replace ;

restore, preserve ;


	keep if asecsurvey == 0 ; 
	collapse (median) ce_rexp_noadj c_rexpk (mean) `tablist1' `tablist3' `tablist4' [aweight=c_popwt], by(c_poor_c_rexpk) ; 
	for var age_ref thousegrp1 thousegrp2 thousegrp3 educt1 educt2 educt3 race1 race2 race3 race4: ren X c_X;
	ren ce_rexp_noadj c_rexp_noadj ; 
	gen _mi_miss=0;
	gen _mi_id=0;
	mi extract 0, clear;
	reshape long c_, i(c_poor_c_rexpk) j(variable) str ;
	keep if !mi(c_poor_c_rexpk) ;
	reshape wide c_, i(variable) j(c_poor_c_rexpk) ;
	keep if !mi(c_0) & !mi(c_1) ; 
	keep variable c_1 ; 
	ren c_1 sepm_poor ;
	
	merge 1:1 variable using "${temp}99 SIPM poor means.dta", nogen ; 
	replace variable = "Gross Expenditure or Gross Adjusted Income" if inlist(variable,"rinc_aftertax","rexp_noadj");
	replace variable = "Net Expenditure or Net Adjusted Income" if inlist(variable,"rinc_aftertax_net","rexpk");
	replace variable = "MOOP" if variable == "rhealth";
	replace variable = "Work Expenses + Childcare" if variable == "rCapWknChCareXpns";
	replace variable = "Child Support" if variable == "rchildsupport";
	replace variable = "Total Adjustments" if variable == "adjust_notax";
	replace variable = "Taxes (2% Topcode)" if variable == "rtaxtopped" ;
	replace variable = "School Lunch Subsidy" if variable == "rschlunch";
	replace variable = "Energy Asst." if variable == "rliheap";
	replace variable = "SNAP" if variable == "rsnap";
	replace variable = "WIC" if variable == "rwic";
	replace variable = "Total In-Kind" if variable == "noncash";
	replace variable = "Total In-Kind" if variable == "total_inkind_nosnap";
	replace variable = "Housing Subsidy" if variable == "rhousesub";
	replace variable = "Family Size" if variable == "fam_size";
	replace variable = "Children" if variable == "nchild";
	replace variable = "Adults" if variable == "nadult";
	replace variable = "Presence of Elderly" if variable == "elderly";
	replace variable = "Own w/ Mortgage" if variable == "thousegrp1";
	replace variable = "Own w/o Mortgage" if variable == "thousegrp2";
	replace variable = "Renters" if variable == "thousegrp3";
	replace variable = "Age" if variable == "age_ref" ;
	replace variable = "< High School" if variable == "educt1";
	replace variable = "High School" if variable == "educt2";
	replace variable = "AS, BA, or More" if variable == "educt3";
	replace variable = "White" if variable == "race1";
	replace variable = "Black" if variable == "race2";
	replace variable = "Hispanic" if variable == "race3";
	replace variable = "Other Race" if variable == "race4";


	for var sepm_poor sipm_poor : replace X = 0 if mi(X) ; 
	collapse (sum) *_poor , by(variable) ; 
	
	gen t_sort = _n ;
	replace t_sort = 1 if variable == "Gross Expenditure or Gross Adjusted Income" ;
	replace t_sort = 2 if variable == "Net Expenditure or Net Adjusted Income" ;
	replace t_sort = 3 if variable == "MOOP" ;
	replace t_sort = 4 if variable == "Work Expenses + Childcare" ;
	replace t_sort = 5 if variable == "Child Support"  ;
	replace t_sort = 6 if variable == "Total Adjustments" ;
	replace t_sort = 7 if variable == "Taxes (2% Topcode)"  ;
	replace t_sort = 8 if variable == "School Lunch Subsidy" ;
	replace t_sort = 9 if variable == "Energy Asst."  ;
	replace t_sort = 10 if variable == "SNAP";
	replace t_sort = 11 if variable == "WIC"  ;
	replace t_sort = 12 if variable == "Housing Subsidy"  ;
	replace t_sort = 13 if variable == "Total In-Kind" ;
	replace t_sort = 14 if variable == "Family Size"  ;
	replace t_sort = 15 if variable == "Children"  ;
	replace t_sort = 16 if variable == "Adults"  ;
	replace t_sort = 17 if variable == "Presence of Elderly";
	replace t_sort = 18 if variable == "Own w/ Mortgage" ;
	replace t_sort = 19 if variable == "Own w/o Mortgage" ;
	replace t_sort = 20 if variable == "Renters"  ;
	replace t_sort = 21 if variable == "< High School";
	replace t_sort = 22 if variable == "High School" ;
	replace t_sort = 23 if variable == "AS, BA, or More";
	replace t_sort = 24 if variable == "White" ;
	replace t_sort = 25 if variable == "Black" ;
	replace t_sort = 26 if variable == "Hispanic";
	replace t_sort = 27 if variable == "Other Race";
	sort t_sort ; 
	drop t_sort;
	label var variable " " ; 
	label var sepm_poor "SEPM" ; 
	label var sipm_poor "SIPM" ;

	foreach var in sepm_poor sipm_poor{;
		levelsof `var' if variable == "SNAP", local(snap);
		replace `var' = `var' - `snap' if variable == "Total In-Kind";
	};
	drop if inlist(variable,"Taxes (2% Topcode)","SNAP") ; 

	export excel using "${outgraph}99 Tables.xlsx", sheet("r.Table A1") sheetreplace firstrow(varlabel) ; 
	

restore ; 

log close; 
